@extends('adminlte::page')


@section('title', 'Sistema TI')

@section('content_header')
       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-sm-10">
            <h1 class="m-0 text-dark">Compras</h1>
        </div>
        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">
            <a href="{{route('compras.create')}}" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>
        </div>
    </div>
@stop

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="">
                                    @if($equipos->count()>0)
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                 
                                                    <th>Pedido</th>
                                                    <th>Fecha</th>
                                                    <th>Tarjeta</th>
                                                    <th>Monto</th>
                                                    <th style="width:75px;"  class="noExport">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($equipos as $nivel)
                                                    <tr>
                                                    <td>
                                                            {{$nivel->num_pedido}}
                                                        </td>
                                                        <td>
                                                            {{date_format(date_create($nivel->fecha),"d-m-Y")}}
                                                        </td>
                                                        
                                                      
                                                        <td>
                                                            {{$nivel->num_tarjeta}}
                                                        </td>
                                                      <td class="text-end">
                                                        {{$nivel->monto}}
                                                      </td>
                                                        
                                                        <td style="width:125px;" >
                                                            <div class="d-flex">
                                                            <a href="#" onclick="loadPurchase({{$nivel->id}})"  class="btn btn-success text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-eye"></i>
                                                            </a>
                                                             <a href="{{route('compras.edit',[$nivel])}}"  class="btn btn-warning text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-edit"></i>
                                                            </a> 
                                                         
                                                            <form action='{{route("inventario.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->id}},1)">
                                                                    @method("delete")
                                                                    @csrf
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                       
                                                        </td>
                                                           
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <tr style="display:none">
                                                    <td><strong>Total</strong></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td  class="text-end"><strong>{{$total->monto}}</strong></td>
                                                    <td></td>
                                                </tr>
                                            </tbody>
                                            <tfooter>
                                                <tr>
                                                    <td><strong>Total</strong></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td  class="text-end"><strong>{{$total->monto}}</strong></td>
                                                    <td></td>
                                                </tr>
                                            </tfooter>
                                        </table>    
                                    @endif
                                    @if($equipos->count()==0)
                                        <h2>No hay inventario</h2>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("compras.index");?>
    <input type="hidden" value="{{$route2}}" id="route" />
@include('compras/includes/modal')
    <script src="{{ URL::asset('js/compras/list.js')}}?v={{AppHelper::getVersion()}}"></script>   
@stop
