<?php

namespace App\Http\Controllers;

use App\Models\TiCompra;
use Illuminate\Http\Request;

class ComprasController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function getData(Request $request){
        $input = $request->all();
        $equipo = TiCompra::where('status','<=','1')->where("id","=",$input['id'])->first();

        $view=view('compras.data',['equipo'=>$equipo]);
        echo $view;
    }
    public function index()
    {
        //
        $equipos = TiCompra::where('status','<=','1')->get();
        $total = \DB::select("select sum(monto) as monto from ti_compras where status=1");
        $data=[
            "equipos"=>$equipos,
            "total"=>$total[0]
        ];
        return view("compras.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $data=[];
        return view('compras.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiCompra($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo['carpeta']=date('Y_m_d')."_"."Compra_".$this->generarCadenaAleatoria(5)."";
            $ruta ="assets/compras/".$equipo['carpeta'];
            if (!file_exists($ruta)) {
                mkdir($ruta, 0777, true);
            }
            $fac =$this->imagen($request->file('fac'),parent::getURL()."assets/compras/".$equipo['carpeta']);
            $carta =$this->imagen($request->file('carta'),parent::getURL()."assets/compras/".$equipo['carpeta']);
            $xml =$this->imagen($request->file('xml'),parent::getURL()."assets/compras/".$equipo['carpeta']);
            $equipo['fac']=$fac;
            $equipo['xml']=$xml;
            $equipo['carta']=$carta;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $equipo = TiCompra::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('compras.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiCompra::where('id','=',$input['id'])->first();
            $equipo->num_pedido =$input['num_pedido'];
            $equipo->num_tarjeta =$input['num_tarjeta'];
            $equipo->fecha =$input['fecha'];
          
            $equipo->monto =$input['monto'];
            $ruta ="assets/compras".$equipo->carpeta;
            if (!file_exists($ruta)) {
                mkdir($ruta, 0777, true);
            }
            if(!empty($request->file('fac'))){
                $fac =$this->imagen($request->file('fac'),parent::getURL()."assets/compras".$equipo['carpeta']);
                $equipo['fac']=$fac;
            }
            if(!empty($request->file('carta'))){
                $carta =$this->imagen($request->file('carta'),parent::getURL()."assets/compras".$equipo['carpeta']);
                $equipo['carta']=$carta;
            }
            if(!empty($request->file('xml'))){
                $xml =$this->imagen($request->file('xml'),parent::getURL()."assets/compras".$equipo['carpeta']);
                $equipo['xml']=$xml;
            }
           
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiCompra::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
