<?php

namespace App\Http\Controllers;

use App\Models\TiProveedore;
use Illuminate\Http\Request;

class ProveedoresController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function index()
    {
        //
        $equipos = TiProveedore::where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("proveedores.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $data=[];
        return view('proveedores.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiProveedore($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $equipo = TiProveedore::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('proveedores.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiProveedore::where('id','=',$input['id'])->first();
            $equipo->nombre =$input['nombre'];
            $equipo->servicio =$input['servicio'];
            $equipo->url =$input['url'];
            $equipo->telefono =$input['telefono'];
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiProveedore::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
