<?php

namespace App\Http\Controllers;

use App\Models\TiDvr;
use Illuminate\Http\Request;

class CamarasDVRController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function index()
    {
        //
        $equipos = TiDvr::where('tipo','=',0)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("camaras.index",$data);
    }
    
    public function dvr()
    {
        //
        $equipos = TiDvr::where('tipo','=',1)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("dvr.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $data=[];
        return view('camaras.add');
    }
    public function dvr_create()
    {
        //
        $data=[];
        return view('dvr.add');
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiDvr($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $equipo = TiDvr::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('camaras.edit',$data);
    }
    public function dvr_edit(string $id)
    {
        //
        $equipo = TiDvr::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('dvr.edit',$data);
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiDvr::where('id','=',$input['id'])->first();
            $equipo->nombre =$input['nombre'];
            $equipo->ip =$input['ip'];
            $equipo->analogica =$input['analogica'];
            $equipo->digital =$input['digital'];
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiDvr::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
