<?php

namespace App\Http\Controllers;

use App\Models\Usuario;
use Illuminate\Http\Request;
use App\Models\User;

class UsuariosController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
       // $this->crearBitacora("Usuarios","Listado");
        $_SESSION['search'] = "";
        $_SESSION['limit']="";
        $Users=Usuario::where('idUsuario','>','1')->where("estado","<=","2")->get();
        $data = [
            'usuarios'=>$Users,
            'search'=>"",
            'limit'=>10
        ];
        return view('usuarios.index',$data);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
       // $this->crearBitacora("Usuarios","Crear");
        return view('usuarios.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
       // $this->crearBitacora("Usuarios","Crea usuario");
        $input =$request->all();
        $datos = $input['usuario'];
        $usuario=Usuario::where('email','=',$datos['usuario'])->first();
        if(empty($usuario)){
            $usuario=new Usuario([
                'email'=>$datos['usuario'],
                'password'=>md5($datos['pass']),
                'typeuser'=>$datos['typeUser'],
                "estado"=>1,
            ]);
            try{
                $usuario->save();
                echo'true';
            }catch(\Illuminate\Database\QueryException $e){
                echo 'false';
            }
        }else{
            echo "false";
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
       // $this->crearBitacora("Usuarios","Editar");
        $usuario=Usuario::where('idUsuario','=',$id)->first();
        $data =[
            'usuario'=>$usuario
        ];
        return view('usuarios.edit',$data);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function perfil()
    {
        //
        $usuario=Usuario::where('idUsuario','=',$_SESSION['id'])->first();
        $data =[
            'usuario'=>$usuario
        ];
        return view('usuarios.perfil',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
       //$this->crearBitacora("Usuarios","Actualiza usuario");
        $input =$request->all();
        $datos = $input['usuario'];
        $usuario=Usuario::where('idUsuario','=',$datos['idUsuario'])->first();
      
        if(!empty($usuario)){
            $usuario=Usuario::where('idUsuario','=',$datos['idUsuario'])->first();
            $usuario->email=$datos['usuario'];
            //$usuario->password=$datos['pass'];
            $usuario->typeuser=$datos['typeUser'];
           // $usuario-> nombre=$datos['nombre'];
            try{
                $usuario->save();
                echo json_encode(true);
            }catch(\Illuminate\Database\QueryException $e){
                \Log::emergency(json_encode($e));
                echo json_encode(false);
            }
        }else{
            echo json_encode(false);
        }
    }
   

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
        //$this->crearBitacora("idUsuario","Eliminar");
        $input =$request->all();
        
        $usuario=Usuario::where('idUsuario','=', $input['id'])->first();
        try{
            $usuario->estado=3;
            $usuario->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function status(Request $request)
    {
        //
        //$this->crearBitacora("Usuarios","Actualiza estado");
        $input =$request->all();
        
        $usuario=Usuario::where('idUsuario','=', $input['id'])->first();
        try{
            $usuario->estado=$input["estado"]==0?1:0;
            $usuario->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function profile(Request $request){
       
    }
}
