<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Usuario
 * 
 * @property int $id
 * @property string $sistema
 * @property string $nombre
 * @property string $apellidos
 * @property string|null $telefono
 * @property int $estado
 * @property int|null $tipoUsuarioAgenda
 * @property int|null $iddepartamento
 * @property string $email
 * @property string $password
 * @property int|null $usuariocreado
 * @property string|null $codigo_persona
 * @property string $imagen
 * @property Carbon $creado
 * @property Carbon|null $modificado
 * @property Carbon|null $eliminado
 * @property int $nativo
 * @property int $isDeleted
 * @property int|null $tipoUsuarioCapacitacion
 * @property int|null $tipoUsuariohelpDesk
 * @property int|null $tipoUsuarioChecador
 * @property string $passwordChecador
 * @property int|null $curso
 * @property int $rol
 * @property int|null $idEmpresa
 * @property int|null $all_documentos
 * @property int|null $admin_actividad
 * @property int|null $isActive
 *
 * @package App\Models
 */
class Usuario extends Model
{
	protected $table = 'usuarios';
	public $timestamps = false;

	protected $casts = [
		'estado' => 'int',
		'tipoUsuarioAgenda' => 'int',
		'iddepartamento' => 'int',
		'usuariocreado' => 'int',
		'creado' => 'datetime',
		'modificado' => 'datetime',
		'eliminado' => 'datetime',
		'nativo' => 'int',
		'isDeleted' => 'int',
		'tipoUsuarioCapacitacion' => 'int',
		'tipoUsuariohelpDesk' => 'int',
		'tipoUsuarioChecador' => 'int',
		'curso' => 'int',
		'rol' => 'int',
		'idEmpresa' => 'int',
		'all_documentos' => 'int',
		'admin_actividad' => 'int',
		'isActive' => 'int'
	];

	protected $hidden = [
		'password'
	];

	protected $fillable = [
		'sistema',
		'nombre',
		'apellidos',
		'telefono',
		'estado',
		'tipoUsuarioAgenda',
		'iddepartamento',
		'email',
		'password',
		'usuariocreado',
		'codigo_persona',
		'imagen',
		'creado',
		'modificado',
		'eliminado',
		'nativo',
		'isDeleted',
		'tipoUsuarioCapacitacion',
		'tipoUsuariohelpDesk',
		'tipoUsuarioChecador',
		'passwordChecador',
		'curso',
		'rol',
		'idEmpresa',
		'all_documentos',
		'admin_actividad',
		'isActive'
	];
}
