@extends('adminlte::page')


@section('title', 'Sistema TI')

@section('content_header')
       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-sm-10">
            <h1 class="m-0 text-dark">Inventario Equipos</h1>
        </div>
        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">
            <a href="{{route('inventario.create')}}" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>
        </div>
    </div>
@stop

@section('content')
    <style>
        .d-none2{

        }
    </style>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="">
                                    @if($equipos->count()>0)
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                    <th class="d-none">Departamento</th>
                                                    <th  class="d-">Ubicación</th>
                                                    <th  class="d-">Usuario</th>
                                                    <th>Marca</th>
                                                    <th>Modelo</th>
                                                    <th>Número de Serie</th>
                                                   
                                                    <th>Tipo</th>
                                                    <th  class="d-none">SO</th>
                                                    <th  class="d-none">IP</th>
                                                    <th  class="d-none">MAC</th>
                                                     <th  class="d-none">MAC Wifi</th>
                                                    <th  class="d-none">Licencia</th>
                                                    <th  class="d-none">Costo</th>
                                                    <th style="width:75px;" class="d-none2 noExport">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($equipos as $nivel)
                                                    <tr>
                                                    <td class="d-none">
                                                            {{$nivel->departamento}}
                                                        </td>
                                                    <td  class="d-"> {{$nivel->ubicacion}}</td>
                                                    <td  class="d-"> {{$nivel->usuario}}</td>
                                                        <td>
                                                            {{$nivel->marca}}
                                                        </td>
                                                        <td>
                                                            {{$nivel->modelo}}
                                                        </td>
                                                      
                                                        <td>
                                                            {{$nivel->numero_serie}}
                                                        </td>
                                                       
                                                        <td>
                                                            {{(($nivel->isPC==0)?'PC':'Portatil')}}
                                                        </td>
                                                        <td  class="d-none"> {{$nivel->so}}</td>
                                                        <td  class="d-none"> {{$nivel->ip}}</td>
                                                        <td  class="d-none"> {{$nivel->mac}}</td>
                                                        <td  class="d-none"> {{$nivel->id_equipo}}</td>
                                                        <td  class="d-none"> {{$nivel->licencia}}</td>
                                                        <td  class="d-none"> {{$nivel->costo}}</td>
                                                     
                                                        <td style="width:125px;" class="d-none2 noExport" >
                                                            <div class="d-flex">
                                                            
                                                             <a href="{{route('inventario.edit',[$nivel])}}"  class="btn btn-warning text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-edit"></i>
                                                            </a> 
                                                         
                                                            <form action='{{route("inventario.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->id}},1)">
                                                                    @method("delete")
                                                                    @csrf
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                       
                                                        </td>
                                                           
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>    
                                    @endif
                                    @if($equipos->count()==0)
                                        <h2>No hay inventario</h2>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("inventario.index");?>
    <input type="hidden" value="{{$route2}}" id="route" />

    <script src="{{ URL::asset('js/inventario/list.js')}}?v={{AppHelper::getVersion()}}"></script>   
@stop
