<?php


use App\Http\Controllers\AjaxController;
use App\Http\Controllers\AnydeskController;
use App\Http\Controllers\CamarasDVRController;
use App\Http\Controllers\ComprasController;
use App\Http\Controllers\ConmutadorController;
use App\Http\Controllers\DashboardController;

use App\Http\Controllers\DirectorioController;
use App\Http\Controllers\EquiposController;
use App\Http\Controllers\MovimientosController;
use App\Http\Controllers\ProveedoresController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\VPNController;
use Illuminate\Support\Facades\Route;


use App\Http\Controllers\AuthController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/admin/autoLogin',[AuthController::class, 'autoLogin'])->name("dashboard.autoLogin");


Route::get('/admin/dashboard',[DashboardController::class, 'index'])->name("dashboard.index");


Route::get('/admin/inventario/ups',[EquiposController::class, 'ups'])->name("inventario.ups");
Route::get('/admin/inventario/monitores',[EquiposController::class, 'monitores'])->name("inventario.monitores");
Route::get('/admin/inventario/moviles',[EquiposController::class, 'moviles'])->name("inventario.moviles");
Route::get('/admin/inventario/inventario',[EquiposController::class, 'inventario'])->name("inventario.inventario");
Route::get('/admin/inventario/impresoras',[EquiposController::class, 'impresoras'])->name("inventario.impresoras");
Route::get('/admin/inventario/accesorios',[EquiposController::class, 'accesorios'])->name("inventario.accesorios");


Route::get('/admin/inventario/ups/add',[EquiposController::class, 'ups_add'])->name("inventario.ups_add");
Route::get('/admin/inventario/monitores/add',[EquiposController::class, 'monitores_add'])->name("inventario.monitores_add");
Route::get('/admin/inventario/moviles/add',[EquiposController::class, 'moviles_add'])->name("inventario.moviles_add");
Route::get('/admin/inventario/impresoras/add',[EquiposController::class, 'impresoras_add'])->name("inventario.impresoras_add");
Route::get('/admin/inventario/accesorios/add',[EquiposController::class, 'accesorios_add'])->name("inventario.accesorios_add");


Route::get('/admin/inventario/ups/edit/{id}',[EquiposController::class, 'ups_edit'])->name("inventario.ups_edit");
Route::get('/admin/inventario/monitores/edit/{id}',[EquiposController::class, 'monitores_edit'])->name("inventario.monitores_edit");
Route::get('/admin/inventario/moviles/edit/{id}',[EquiposController::class, 'moviles_edit'])->name("inventario.moviles_edit");
Route::get('/admin/inventario/impresoras/edit/{id}',[EquiposController::class, 'impresoras_edit'])->name("inventario.impresoras_edit");
Route::get('/admin/inventario/accesorios/edit/{id}',[EquiposController::class, 'accesorios_edit'])->name("inventario.accesorios_edit");



Route::resource('admin/inventario',EquiposController::class);
Route::post('admin/inventario/store',[EquiposController::class, 'store'])->name('inventario.store');
Route::post('admin/inventario/update',[EquiposController::class, 'update'])->name('inventario.update');
Route::post('admin/inventario/destroy',[EquiposController::class, 'destroy'])->name('inventario.destroy');
Route::post('admin/inventario/status',[EquiposController::class, 'status'])->name('inventario.status');

Route::resource('admin/anydesk',AnydeskController::class);
Route::post('admin/anydesk/store',[AnydeskController::class, 'store'])->name('anydesk.store');
Route::post('admin/anydesk/update',[AnydeskController::class, 'update'])->name('anydesk.update');
Route::post('admin/anydesk/destroy',[AnydeskController::class, 'destroy'])->name('anydesk.destroy');
Route::post('admin/anydesk/status',[AnydeskController::class, 'status'])->name('anydesk.status');

Route::resource('admin/vpn',VPNController::class);
Route::post('admin/vpn/store',[VPNController::class, 'store'])->name('vpn.store');
Route::post('admin/vpn/update',[VPNController::class, 'update'])->name('vpn.update');
Route::post('admin/vpn/destroy',[VPNController::class, 'destroy'])->name('vpn.destroy');
Route::post('admin/vpn/status',[VPNController::class, 'status'])->name('vpn.status');

Route::resource('admin/pin',DirectorioController::class);
Route::post('admin/pin/store',[DirectorioController::class, 'store'])->name('pin.store');
Route::post('admin/pin/update',[DirectorioController::class, 'update'])->name('pin.update');
Route::post('admin/pin/destroy',[DirectorioController::class, 'destroy'])->name('pin.destroy');
Route::post('admin/pin/status',[DirectorioController::class, 'status'])->name('pin.status');

Route::resource('admin/proveedores',ProveedoresController::class);
Route::post('admin/proveedores/store',[ProveedoresController::class, 'store'])->name('proveedores.store');
Route::post('admin/proveedores/update',[ProveedoresController::class, 'update'])->name('proveedores.update');
Route::post('admin/proveedores/destroy',[ProveedoresController::class, 'destroy'])->name('proveedores.destroy');
Route::post('admin/proveedores/status',[ProveedoresController::class, 'status'])->name('proveedores.status');

Route::resource('admin/conmutador',ConmutadorController::class);
Route::post('admin/conmutador/store',[ConmutadorController::class, 'store'])->name('conmutador.store');
Route::post('admin/conmutador/update',[ConmutadorController::class, 'update'])->name('conmutador.update');
Route::post('admin/conmutador/destroy',[ConmutadorController::class, 'destroy'])->name('conmutador.destroy');
Route::post('admin/conmutador/status',[ConmutadorController::class, 'status'])->name('conmutador.status');

Route::resource('admin/compras',ComprasController::class);
Route::post('admin/compras/store',[ComprasController::class, 'store'])->name('compras.store');
Route::post('admin/compras/update',[ComprasController::class, 'update'])->name('compras.update');
Route::post('admin/compras/destroy',[ComprasController::class, 'destroy'])->name('compras.destroy');
Route::post('admin/compras/getData',[ComprasController::class, 'getData'])->name('compras.getData');

Route::resource('admin/movimientos',MovimientosController::class);
Route::post('admin/movimientos/store',[MovimientosController::class, 'store'])->name('movimientos.store');
Route::post('admin/movimientos/destroy',[MovimientosController::class, 'destroy'])->name('movimientos.destroy');
Route::post('admin/movimientos/getData',[MovimientosController::class, 'getData'])->name('movimientos.getData');
Route::post('admin/movimientos/update_comment',[MovimientosController::class, 'update_comment'])->name('movimientos.update_comment');

Route::get('/admin/dvr',[CamarasDVRController::class, 'dvr'])->name("dvr.index");
Route::get('/admin/dvr/create',[CamarasDVRController::class, 'dvr_create'])->name("dvr.create");
Route::get('/admin/dvr/edit/{id}',[CamarasDVRController::class, 'dvr_edit'])->name("dvr.edit");
Route::resource('admin/camaras',CamarasDVRController::class);
Route::post('admin/camaras/store',[CamarasDVRController::class, 'store'])->name('camaras.store');
Route::post('admin/camaras/update',[CamarasDVRController::class, 'update'])->name('camaras.update');
Route::post('admin/camaras/destroy',[CamarasDVRController::class, 'destroy'])->name('camaras.destroy');
Route::post('admin/camaras/status',[CamarasDVRController::class, 'status'])->name('camaras.status');

Route::get('admin/reportes/usuario',[ReportController::class, 'historial_usuario'])->name('reportes.historial_usuario');
Route::get('admin/reportes/historial',[ReportController::class, 'historial'])->name('reportes.historial');
Route::get('admin/reportes/estados',[ReportController::class, 'estados'])->name('reportes.estados');
Route::resource('admin/reportes',ReportController::class);
Route::post('admin/reportes/getHistorialUsuario',[ReportController::class, 'getHistorialUsuario'])->name('reportes.getHistorialUsuario');
Route::post('admin/reportes/getHistorial',[ReportController::class, 'getHistorial'])->name('reportes.getHistorial');
Route::post('admin/reportes/getEstados',[ReportController::class, 'getEstados'])->name('reportes.getEstados');
