<?php

require_once __DIR__."/../config/globals.php";

require_once  __DIR__."/../repository/DepartamentosRepository.php";


require_once  __DIR__."/Controller.php";





class DepartamentosController extends Controller{

    private $departamentoRepository;

    public function __construct()

    {

       $this->departamentoRepository = new DepartamentosRepository(); 
    }


    public function list(){

        $data=$this->departamentoRepository->list();
        $this->listActivos();
        return $data;

    }
    public function listActivos(){
        $departamentos = $this->departamentoRepository->listActivos();
        $_SESSION["departamentos"]=$departamentos;
    }
    public function crearDepartamento($departamento){
        $this->departamentoRepository->crearDepartamento($departamento);
        $this->listActivos();
        
        echo 'true';
    }
    public function actualizarDepartamento($departamento){
        $this->departamentoRepository->actualizarDepartamento($departamento);
        $this->listActivos();
        echo 'true';
    }
    public function eliminarDepartamento($id){
        $this->departamentoRepository->eliminarDepartamento($id);
        $this->listActivos();
        echo 'true';
    }
    public function statusDepartamento($id){
        $departamento = $this->departamentoRepository->departamento($id);

        $status = $departamento->estado==1?0:1;
        $this->departamentoRepository->statusDepartamento($id,$status);
        $this->listActivos();
        echo 'true';
    }
    public function departamentoPorId($id){
        $departamento = $this->departamentoRepository->departamento($id);
        return $departamento;
    }
}
?>