

$(document).ready(function () {

    if ($("table").length == 0) {

      $(".spin").css("display", "none");

    }

    $("table").DataTable({

      destroy: true,

      language: {

        url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",

      },

      responsive: true,

      order: [],

      columnDefs: [

        { width: "50px", sortable: false, targets: 2 },

        //  { "width": "50px","sortable":false, "targets": 2 }

      ],

      //dom: 'Bfrtip',

      buttons: [],

      initComplete: function () {

        $(".spin").css("display", "none");

      },

    });

  });

  

  const removeItem = (id) => {

    confirmacionEliminar(

      "¿Desea eliminar el Banner?",

      "Aceptar",

      "Cancelar",

      function (response) {

        if (response) {

          let form = new FormData();

          $.ajaxSetup({

            headers: {

              "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

            },

          });

          console.log(id);

          form.append("id", id);

          $.ajax({

            type: "POST",

            url: "./admin/api/banners.php?action=delete",

            data: form,

            processData: false,

            contentType: false,

            success: function (data) {

              console.log(data);

              $(".spin").css("display", "none");

              let json = JSON.parse(data);

              console.log(json);

              if (json) {

                let rsp = alertTimeCorrect(

                  "Excelente",

                  "Banner eliminado",

                  function (response) {

                    window.location.reload();

                  }

                );

              } else {

                alertError("Error", "No se eliminó el Banner");

              }

            },

            error: function (data) {

              console.log(data);

              $(".spin").css("display", "none");

              alertError("Error en el servidor");

            },

          });

        }

      }

    );

  };

  



  

  const statusItem = (id) => {

    confirmacionEliminar(

      "¿Desea cambiar el estado del Banner?",

      "Aceptar",

      "Cancelar",

      function (response) {

        if (response) {

          let form = new FormData();

          $.ajaxSetup({

            headers: {

              "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

            },

          });

          console.log(id);

          form.append("id", id);

          $.ajax({

            type: "POST",

            url: "./admin/api/banners.php?action=status",

            data: form,

            processData: false,

            contentType: false,

            success: function (data) {

              console.log(data);

              $(".spin").css("display", "none");

              let json = JSON.parse(data);

              console.log(json);

              if (json) {

                let rsp = alertTimeCorrect(

                  "Excelente",

                  "Banner actualizado",

                  function (response) {

                    window.location.reload();

                  }

                );

              } else {

                alertError("Error", "No se actualizó el Banner");

              }

            },

            error: function (data) {

              console.log(data);

              $(".spin").css("display", "none");

              alertError("Error en el servidor");

            },

          });

        }

      }

    );

  };

  