

$(document).ready(function () {

    if ($("table").length == 0) {

        $(".spin").css("display", "none");

    }

    $("table").DataTable({

        destroy: true,

        language: {

            url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",

        },

        responsive: true,

        order: [],

        columnDefs: [

            { width: "50px", sortable: false, targets:4 },

            //  { "width": "50px","sortable":false, "targets": 2 }

        ],

        //dom: 'Bfrtip',

        buttons: [],

        initComplete: function () {

            $(".spin").css("display", "none");

        },

    });

});



const removeItem = (id) => {

    confirmacionEliminar(

        "¿Desea eliminar el mensaje?",

        "Aceptar",

        "Cancelar",

        function (response) {

            if (response) {

                let form = new FormData();

                $.ajaxSetup({

                    headers: {

                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

                    },

                });

                console.log(id);

                form.append("id", id);

                $.ajax({

                    type: "POST",

                    url: "./admin/api/buzon.php?action=delete",

                    data: form,

                    processData: false,

                    contentType: false,

                    success: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        let json = JSON.parse(data);

                        console.log(json);

                        if (json) {

                            let rsp = alertTimeCorrect(

                                "Excelente",

                                "Mensaje eliminado",

                                function (response) {

                                    window.location.reload();

                                }

                            );

                        } else {

                            alertError("Error", "No se eliminó el mensaje");

                        }

                    },

                    error: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        alertError("Error en el servidor");

                    },

                });

            }

        }

    );

};


