<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;

use GuzzleHttp\Client;

use App\Models\Historial;
use App;
//SECRET WEB   6Lde6uwlAAAAAB-mnZvPvpwX_7LoTGVTcDJvqx4T
//SECRET KEY   6Lde6uwlAAAAANjI_8xqb3r58yT44mtNvszCmNuE
session_start();
class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct(Request $request){
       
        if(!isset($_SESSION['languaje'])){
            $_SESSION['languaje']="en";
        }
        if(empty($_SESSION['languaje'])){
            $_SESSION['languaje']="en";
        }
        App::setLocale( $_SESSION['languaje']);
        if(isset($_SESSION["login"])){
            $_SESSION["login"]="";
        }
        if($request->isMethod('get') && $request->is("admin/*") && (!$request->is("admin/login") && !$request->is("admin/recuperar*"))){
            //Acciones luego de validar.
            
            if(!isset($_SESSION["id"])){
                echo "<script>window.location.href='/admin/login';</script>";
                return redirect()->to("/admin/login");
            }else if($_SESSION["id"]==""){
                echo "<script>window.location.href='/admin/login';</script>";
                return redirect()->to("/admin/login");
            }
            
            
              $dateActual=date('Y-m-d');
            $historial = Historial::orderby("idHistorial","DESC")->get();
            foreach ($historial as $key => $value) {
                $creado =date_create($value->fecha);
                $maximoTiempo = "30";
                    $f = "$maximoTiempo days";
                    $newdate = date_add($creado,date_interval_create_from_date_string($f));
                
                    $actual = date_create($dateActual);
                    if($actual>=$newdate){
                        $value->delete();
                        \Log::info("Historial borrado");
                        \Log::info(json_encode($value));
                    }
            }
           
        }
        if(isset($_SESSION["id"])){
             if(isset($_SESSION["typeuser"])){
                if($_SESSION["typeuser"]==2){
    
                    $historial=Historial::where("idUsuario","=",$_SESSION["id"])->orderby("idHistorial","DESC")->first();
                    if(!empty($historial)){
                        $fecha = date_create($historial->fecha);
                        $fechaActual =  date_create("now");
                        $fechaFormateada = date_format($fechaActual,"Y-m-d h:i:s");
            
                        $new_date = date_create($fechaFormateada);
                        $difference = date_diff($fecha, $new_date); 
                        $minutes = $difference->days * 24 * 60;
                        $minutes += $difference->h * 60;
                        $minutes += $difference->i;
                        $historial->tiempoMinutos = $minutes;
                        $historial->save();
                    }
                  
                }
             }
            
       
            
        }
    }

    public function getURL(){
        return "./";
    }
    public function imagen($imagen,$ruta){
        
        // $imagen = $request->file('categoria');
         if(empty($imagen)){
             return "";
         }
         $extension = $imagen->getClientOriginalExtension();
         $randomName = $this->generarCadenaAleatoria(15);
         $filename= "File ".$randomName.".".$extension;
      
         $public_path = public_path($ruta);
         while(file_exists($public_path."/".$filename)){
             $filename= "File ".$randomName.".".$extension;
         }
        
         $path = $ruta."/".$filename;
         $imagen->move($public_path,$filename);
         return $filename;
     }
 
     function generarCadenaAleatoria($length = 10)
     {
         return substr(str_shuffle(str_repeat($x = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length / strlen($x)))), 1, $length);
     }
}
