<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Empresa;
use App\Models\Empleado;
use App\Models\Curso;
class CursosController extends Controller
{
    //
    public function __construct(Request $request){
        parent::__construct($request);
    }

    public function index()
    {
        //
      
        if($_SESSION["isAdmin"]==0){
            $cursos=Curso::get();
        }else{
            $cursos=Curso::where("idEmpresa","=",$_SESSION["empresa"]->idEmpresa)->get();
        }
      
        $data = [
            'cursos'=>$cursos,
          
        ];
        return view('cursos.index',$data);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $empresas=Empresa::get();
        return view('cursos.add',["empresas"=>$empresas]);
    }

    public function edit(Request $request,$id){
        $curso= Curso::where("idCurso","=",$id)->first();
        $empresas=Empresa::get();
        return view('cursos.edit',["empresas"=>$empresas,"curso"=>$curso]);
    }
    public function store(Request $request){

        try{
            $input = $request->all();
            $img = parent::imagen($request->file('image'),parent::getURL()."assets/cursos");

            $curso = new Curso([
                'nombre'=>$input["nombre"],
                'imagen'=>$img,
                'descripcion'=>$input["descripcion"],
                'cantidadItems'=>0,
                'creado'=>date("Y-m-d"),
                'estado'=>0,
                'idEmpresa'=> $_SESSION['idEmpresa'],
                'idEmpleado'=>$_SESSION["id"]
            
            ]);
            $curso->save();
            echo'true';
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo 'false';
        }
    }
    public function update(Request $request){

        try{
           $input = $request->all();
           $id=$input["id"];
           $curso= Curso::where("idCurso","=",$id)->first();
           if($input["isValid"]=='true'){
            $img = parent::imagen($request->file('image'),parent::getURL()."assets/cursos");
            $curso->imagen=$img;
           }
          
    
            $curso ->nombre=$input["nombre"];
            $curso ->descripcion=$input["descripcion"];
           
            $curso->save();
            echo'true';
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo 'false';
        }
    }

    public function destroy(Request $request)
    {
        //
        $input =$request->all();
        
        $curso=Curso::where('idCurso','=', $input['id'])->first();
        try{
           
          
            $curso->delete();
           
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function status(Request $request)
    {
        //
        $input =$request->all();
        
        $curso=Curso::where('idCurso','=', $input['id'])->first();
        try{
            $curso->estado=$input["estado"] ==1?0:1;
           
            $curso->save();

            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
}
