<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Empresa;
use App\Models\Empleado;
use App\Models\Curso;
class EmpleadosController extends Controller
{
    //
    public function __construct(Request $request){
        parent::__construct($request);
    }
     
    public function index()
    {
        //
      
        if($_SESSION["isAdmin"]==0){
            $empleados=Empleado::get();
        }else{
            $empleados=Empleado::where("idEmpresa","=",$_SESSION["empresa"]->idEmpresa)->get();
        }
      
        $data = [
            'empleados'=>$empleados,
          
        ];
        return view('empleados.index',$data);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $empresas=Empresa::get();
        return view('empleados.add',["empresas"=>$empresas]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $input =$request->all();
        
        $usuario=User::where('name','=',$input['usuario'])->first();
        if(empty($usuario)){
            $usuario=new User([
                'name'=>$input['usuario'],
                'password'=>md5($input['pass']),
                "isFirst"=>1,
                'typeuser'=>2,
                "isEnabled"=>1
            ]);
            try{
                $usuario->save();
                $usuario=User::where('name','=',$input['usuario'])->first();
                $empleado = new Empleado([
                    'nombre_completo'=>$input['nombre'],
                    'isEnabled'=>1,
                    'idUser'=>$usuario->IdUser,
                    "idEmpresa"=>$input["empresa"]
                ]);
                $empleado->save();
                echo'true';
            }catch(\Illuminate\Database\QueryException $e){
                \Log::emergency(json_encode($e));
                echo 'false';
            }
        }else{
            echo "false";
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $empresa = Empresa::where("idEmpresa","=",$_SESSION["idEmpresa"])->first();
        $empleado=Empleado::where('empleados.idEmpleado','=',$id)->join("users","users.IdUser","=","empleados.idUser")->first();
        $cursos_no = Curso::select("curso.*","progreso_empleados.*")->whereRaw("(curso.idEmpresa=".$empresa->idEmpresa." or curso.idEmpresa=0)")->where("curso.estado","=",1)->join("progreso_empleados","progreso_empleados.idCurso","=","curso.idCurso")->whereRaw( "(progreso_empleados.idEmpleado=".$empleado->idEmpleado.")")->orderby("curso.idCurso","DESC")->get();
        foreach($cursos_no as $key=>$c){
           
            if($c->cantidadItems==0){
                $cursos_no[$key]->progreso=0;
            }else{
                $valor = $c->itemsVistos *100;
               
                $valor = $valor / $c->cantidadItems;
               if(intval($valor."")<=100){
                 $cursos_no[$key]->progreso=intval($valor."");  
               }else{
                   $cursos_no[$key]->progreso=100;
               }
                
            }
           


        }
        $data = [
            "cursos"=>$cursos_no,
            "empleado"=>$empleado
        ];
        return view("empleados.show",$data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $empresas=Empresa::get();
        $empleado=Empleado::where('empleados.idEmpleado','=',$id)->join("users","users.IdUser","=","empleados.idUser")->first();
        $data =[
            'empleado'=>$empleado,
            "empresas"=>$empresas
        ];
        return view('empleados.edit',$data);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $input =$request->all();
      
        $empleado=Empleado::where('idEmpleado','=',$input['id'])->first();
            $empleado->nombre_completo=$input['nombre'];
            $usuario=User::where('IdUser','=',$empleado->idUser)->first();
           
            $usuario->name =  $input["usuario"];
            try{
                $empleado->save();
                $usuario->save();
                echo json_encode(true);
            }catch(\Illuminate\Database\QueryException $e){
                \Log::emergency(json_encode($e));
                echo json_encode(false);
            }
        
    }
   

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
        $input =$request->all();
        
        $empleado=Empleado::where('idEmpleado','=', $input['id'])->first();
        try{
            $empleado->isEnabled=$input["estado"];
            $user =User::where("IdUser","=",$empleado->idUser)->first();
            $empleado->delete();
            $user->delete();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function status(Request $request)
    {
        //
        $input =$request->all();
        
        $empleado=Empleado::where('idEmpleado','=', $input['id'])->first();
        try{
            $empleado->isEnabled=$input["estado"] ==1?0:1;
            $user =User::where("IdUser","=",$empleado->idUser)->first();
            $user->isEnabled=$input["estado"] ==1?0:1;
            $empleado->save();
            $user->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
}
