<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Empresa;
class EmpresaController extends Controller
{
    //
    public function __construct(Request $request){
        parent::__construct($request);
    }

    
    public function index()
    {
        //
      
        $empresas=Empresa::get();
        $data = [
            'empresas'=>$empresas,
          
        ];
        return view('empresas.index',$data);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('empresas.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $input =$request->all();
        $img = parent::imagen($request->file('image'),parent::getURL()."assets/empresas");
        $usuario=User::where('name','=',$input['usuario'])->first();
        if(empty($usuario)){
            $usuario=new User([
                'name'=>$input['usuario'],
                'password'=>md5($input['pass']),
                "isFirst"=>1,
                'typeuser'=>1,
                "isEnabled"=>1,
                "imagen"=>$img
            ]);
            try{
                $usuario->save();
                $usuario=User::where('name','=',$input['usuario'])->first();
                $empresa = new Empresa([
                    'nombre'=>$input['nombre'],
                    'isEnabled'=>1,
                    'idUser'=>$usuario->IdUser
                ]);
                $empresa->save();
                echo'true';
            }catch(\Illuminate\Database\QueryException $e){
                \Log::emergency(json_encode($e));
                echo 'false';
            }
        }else{
            echo "false";
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $empresa=Empresa::where('empresa.idEmpresa','=',$id)->first();
        $data =[
            'empresa'=>$empresa
        ];
        return view('empresas.edit',$data);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $input =$request->all();
      
        $empresa=Empresa::where('idEmpresa','=',$input['id'])->first();
            $empresa->nombre=$input['nombre'];
            $usuario=User::where('IdUser','=',$empresa->idUser)->first();
           
            $usuario->name =  $input["usuario"];
            try{
                if($input["isValid"]=='true'){
                    $img = parent::imagen($request->file('image'),parent::getURL()."assets/empresas");
                    $empresa->imagen=$img;
                   }
                $empresa->save();
                $usuario->save();
                echo json_encode(true);
            }catch(\Illuminate\Database\QueryException $e){
                \Log::emergency(json_encode($e));
                echo json_encode(false);
            }
        
    }
   

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
        $input =$request->all();
        
        $empresa=Empresa::where('idEmpresa','=', $input['id'])->first();
        try{
            $empresa->isEnabled=$input["estado"];
            $user =User::where("IdUser","=",$empresa->idUser)->first();
            $empresa->delete();
            $user->delete();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function status(Request $request)
    {
        //
        $input =$request->all();
        
        $empresa=Empresa::where('idEmpresa','=', $input['id'])->first();
        try{
            $empresa->isEnabled=$input["estado"] ==1?0:1;
            $user =User::where("IdUser","=",$empresa->idUser)->first();
            $user->isEnabled=$input["estado"] ==1?0:1;
            $empresa->save();
            $user->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
   
}
