<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Historial;
use App\Models\User;
class HistorialController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
       
        if($_SESSION["typeuser"]==0){
            $historial = Historial::select("users.*","historial.*","empleados.nombre_completo")->join("users","users.IdUser","=","historial.idUsuario")->join("empleados","users.IdUser","=","empleados.idUser")->orderby("historial.idHistorial","DESC")->get();
        }else{
            $historial = Historial::select("users.*","historial.*","empleados.nombre_completo")->join("users","users.IdUser","=","historial.idUsuario")->join("empleados","users.IdUser","=","empleados.idUser")->where("empleados.idEmpresa","=",$_SESSION["empresa"]->idEmpresa)->orderby("historial.idHistorial","DESC")->get();
        }
      

        $data=[
            "historiales"=>$historial
        ];
        return view("historial.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
       
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();
       
        $c=new Historial([
            
            'idUsuario'=>$input["usuario"],
            'fecha'=>$input["fecha"],
            'tiempoMinutos'=>0
        ]);
        try{
            $c->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //

      
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $input =  $request->all();
        $c=Historial::where("idUsuario","=",$input["usuario"])->orderby("idHistorial","DESC")->first();

      
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
        $input =$request->all();
        
        if($input['id']==0){
            $cursos=Historial::where('idHistorial','>', $input['id'])->get();
            try{
               // $curso->estado=$input["estado"] ==1?0:1;
               foreach ($cursos as $key => $curso) {
                # code...
                $curso->delete();
               }
               
    
                echo json_encode(true);
            }catch(\Illuminate\Database\QueryException $e){
                echo json_encode(false);
            }
        }else{
           
            try{
                
                
                 $curso=Historial::where('idHistorial','=', $input['id'])->first();
               // $curso->estado=$input["estado"] ==1?0:1;
               
                $curso->delete();
    
                echo json_encode(true);
            }catch(\Illuminate\Database\QueryException $e){
                echo json_encode($e);
            }
        }
        
      
    }
}
