<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Curso;
use App\Models\Material;
class MaterialController extends Controller
{
    //
    public function __construct(Request $request){
        parent::__construct($request);
    }

    public function index(Request $request,$id){
        $materiales = Material::where("idCurso","=",$id)->get();
        $curso = Curso::where("idCurso","=",$id)->first();
        $data = [
            "materiales"=>$materiales,
            "idCurso"=>$id,
            "curso"=>$curso
        ];
        return view("materiales.index",$data);
    }
    public function create(Request $request,$id){
        $curso = Curso::where("idCurso","=",$id)->first();
        $data = [
            "curso"=>$curso,
            "idCurso"=>$id
        ];
        return view("materiales.add",$data);
    }

    public function edit(Request $request,$id,$idMaterial){
        $curso = Curso::where("idCurso","=",$id)->first();
        $material = Material::where("idMaterial","=",$idMaterial)->first();
        
        
        $data = [
            "curso"=>$curso,
            "idCurso"=>$id,
            "material"=>$material
        ];
        return view("materiales.edit",$data);
    }
    public function store(Request $request){
        try{
            $input = $request->all();
            if($input["tipo"]<=1){

                $archivo = parent::imagen($request->file('archivo'),parent::getURL()."assets/materiales");
            }else{
                $archivo = $input["archivo"];
            }
          

            $material = new Material([
                'nombre'=>$input["nombre"],
                'descripcion'=>$input["descripcion"],
                'creado'=>date("Y-m-d h:i:s"),
                'visibilidad'=>1,

                'tipo'=>$input["tipo"],
                'material'=>$archivo,
                'idCurso'=>$input["idCurso"],
                'tiempo'=>$input["tiempo"]
            
            ]);
            $material->save();
            $curso = Curso::where("idCurso","=",$input["idCurso"])->first();

            $cantidad = intval($curso->cantidadItems."");
            $cantidad = $cantidad + 1;
            $curso->cantidadItems = $cantidad;
            $curso->save();
            echo'true';
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo 'false';
        }
    }

    public function update(Request $request){
        try{
            $input = $request->all();
            if($input["tipo"]==3){
                $archivo = parent::imagen($request->file('archivo'),parent::getURL()."assets/materiales");
            }else{
                $archivo = $input["archivo"];
            }
            $material = Material::where("idMaterial","=",$input["id"])->first();
            $material->nombre=$input["nombre"];
            $material->descripcion=$input["descripcion"];
            $material->tiempo=$input["tiempo"];

            $material->tipo=$input["tipo"];
            $material->material=$archivo;
            $material->save();
            echo'true';
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo 'false';
        }
    }

    public function destroy(Request $request)
    {
        //
        $input =$request->all();
        
        $material=Material::where('idMaterial','=', $input['id'])->first();
        try{
           
          $curso= Curso::where("idCurso","=",$material->idCurso)->first();
          $cantidad = intval($curso->cantidadItems."");
          $cantidad = $cantidad - 1;
          $curso->cantidadItems = $cantidad;
          $curso->save();

            $material->delete();
           
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
    public function status(Request $request)
    {
        //
        $input =$request->all();
        
        $material=Material::where('idMaterial','=', $input['id'])->first();
        try{
           
          $curso= Curso::where("idCurso","=",$material->idCurso)->first();
          $cantidad = intval($curso->cantidadItems."");
          if($input["estado"] ==1){
            $cantidad = $cantidad - 1;
          }else{
            $cantidad = $cantidad + 1;
          }
           
          $curso->cantidadItems = $cantidad;
          $curso->save();
            $material->visibilidad=$input["estado"] ==1?0:1;
           
            $material->save();

            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            echo json_encode(false);
        }
    }
}
