<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Curso
 * 
 * @property int $idCurso
 * @property string $nombre
 * @property string $imagen
 * @property string $descripcion
 * @property int $cantidadItems
 * @property Carbon $creado
 * @property int $estado
 * @property int $idEmpresa
 * @property int $idEmpleado
 * 
 * @property Empresa $empresa
 * @property Empleado $empleado
 * @property Collection|Materiale[] $materiales
 * @property Collection|ProgresoEmpleado[] $progreso_empleados
 *
 * @package App\Models
 */
class Curso extends Model
{
	protected $table = 'curso';
	protected $primaryKey = 'idCurso';
	public $timestamps = false;

	protected $casts = [
		'cantidadItems' => 'int',
		'creado' => 'datetime',
		'estado' => 'int',
		'idEmpresa' => 'int',
		'idEmpleado' => 'int'
	];

	protected $fillable = [
		'nombre',
		'imagen',
		'descripcion',
		'cantidadItems',
		'creado',
		'estado',
		'idEmpresa',
		'idEmpleado'
	];

	public function empresa()
	{
		return $this->belongsTo(Empresa::class, 'idEmpresa');
	}

	

	public function materiales()
	{
		return $this->hasMany(Materiale::class, 'idCurso');
	}

	public function progreso_empleados()
	{
		return $this->hasMany(ProgresoEmpleado::class, 'idCurso');
	}
}
