<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Empleado
 * 
 * @property int $idEmpleado
 * @property string $nombre_completo
 * @property int $idUser
 * @property int $idEmpresa
 * 
 * @property User $user
 * @property Empresa $empresa
 * @property Collection|Curso[] $cursos
 * @property Collection|ProgresoEmpleado[] $progreso_empleados
 *
 * @package App\Models
 */
class Empleado extends Model
{
	protected $table = 'empleados';
	protected $primaryKey = 'idEmpleado';
	public $timestamps = false;

	protected $casts = [
		'idUser' => 'int',
		'idEmpresa' => 'int'
	];

	protected $fillable = [
		'nombre_completo',
		'idUser',
		'idEmpresa',
		'isEnabled'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'idUser');
	}

	public function empresa()
	{
		return $this->belongsTo(Empresa::class, 'idEmpresa');
	}

	public function cursos()
	{
		return $this->hasMany(Curso::class, 'idEmpleado');
	}

	public function progreso_empleados()
	{
		return $this->hasMany(ProgresoEmpleado::class, 'idEmpleado');
	}
}
