<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Empresa
 * 
 * @property int $idEmpresa
 * @property string $nombre
 * @property int $isEnabled
 * 
 * @property Collection|Curso[] $cursos
 * @property Collection|Empleado[] $empleados
 *
 * @package App\Models
 */
class Empresa extends Model
{
	protected $table = 'empresa';
	protected $primaryKey = 'idEmpresa';
	public $timestamps = false;

	protected $casts = [
		'isEnabled' => 'int'
	];

	protected $fillable = [
		'nombre',
		'isEnabled',
		'idUser'
	];

	public function cursos()
	{
		return $this->hasMany(Curso::class, 'idEmpresa');
	}

	public function empleados()
	{
		return $this->hasMany(Empleado::class, 'idEmpresa');
	}
}
