<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Materiale
 * 
 * @property int $idMaterial
 * @property string $nombre
 * @property int $tipo
 * @property string|null $descripcion
 * @property int $visibilidad
 * @property int $creado
 * @property string $material
 * @property int $idCurso
 * 
 * @property Curso $curso
 *
 * @package App\Models
 */
class Material extends Model
{
	protected $table = 'materiales';
	protected $primaryKey = 'idMaterial';
	public $timestamps = false;

	protected $casts = [
		'tipo' => 'int',
		'visibilidad' => 'int',
		
		'idCurso' => 'int'
	];

	protected $fillable = [
		'nombre',
		'tipo',
		'descripcion',
		'visibilidad',
		'creado',
		'material',
		'idCurso',
		'tiempo'
	];

	public function curso()
	{
		return $this->belongsTo(Curso::class, 'idCurso');
	}
}
