@extends('adminlte::page')





@section('title', 'Plataforma De Capacitación')



@section('content_header')

       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js'); }}"></script>

    <div class="row">

        <div class="col-sm-10">

            <h1 class="m-0 text-dark">Cursos llevados por el empleado</h1>

        </div>

        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">

           

        </div>

        <div class="col-sm-12">

            <nav aria-label="breadcrumb">

                <ol class="breadcrumb">

                    <li class="breadcrumb-item"><a href="{{route('empleados.index')}}">Empleados</a></li>

                    <li class="breadcrumb-item active" aria-current="page">Curso del emplado:{{$empleado->nombre_completo}}</li>

                </ol>

            </nav>

        </div>



    </div>

@stop



@section('content')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <div class="row" style="">

                            

                            <div class="col-sm-12">

                                <div class="">

                                    @if($cursos->count()>0)

                                        <table class="table table-striped table-bordered w-100">

                                            <thead>

                                                <tr>

                                                 

                                                    <th>Portada</th>

                                                    <th>Nombre</th>

                                                   

                                                    <th>Progreso</th>

                                                   

                                                </tr>

                                            </thead>

                                            <tbody>

                                                @foreach($cursos as $nivel)

                                                    <tr>

                                                        

                                                    <td>

                                                        <img src="{{asset('assets/cursos/'.$nivel->imagen)}}" style="width:55px"></img>

                                                    </td>

                                                        <td>

                                                            {{$nivel->nombre}}

                                                        </td>

                                                        <td>

                                                            

                                                            <div class="progress">

                                                                <div class="progress-bar" role="progressbar" style="width: {{$nivel->progreso}}%;" aria-valuenow="{{$nivel->progreso}}%" aria-valuemin="0" aria-valuemax="100">{{$nivel->progreso}}%</div>

                                                            </div>

                                                        </td>

                                                      

                                                        

                                                           

                                                        </td>

                                                    </tr>

                                                @endforeach

                                            </tbody>

                                        </table>    

                                    @endif

                                    @if($cursos->count()==0)

                                        <h2>No hay cursos</h2>

                                    @endif

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("cursos.index");?>

    <input type="hidden" value="{{$route2}}" id="route" />



    <script src="{{ URL::asset('js/empleados/curso.js'); }}"></script>   

@stop

