@extends('adminlte::page')



@section('title', 'Plataforma De Capacitación')



@section('content_header')

       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js'); }}"></script>

    <div class="row">

        <div class="col-sm-10">

            <h1 class="m-0 text-dark">Historial</h1>

        </div>

       <div class="col-sm-2 d-flex justify-content-center">

        <form action='{{route("historiales.destroy", [0])}}' method="post" onsubmit="return validate(event,this,0,1)">

                                                                    @method("delete")

                                                                    @csrf

                                                                    <button type="submit" class="btn btn-warning text-white" style="margin-left:5px;">

                                                                        <i class="fa fa-trash"></i> 

                                                                    </button>

                                                                </form>

       </div>

    </div>

@stop



@section('content')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <div class="row" style="">

                            

                            <div class="col-sm-12">

                                <div class="">

                                    @if($historiales->count()>0)

                                        <table class="table table-striped table-bordered w-100">

                                            <thead>

                                                <tr>

                                                    <th>Nombre</th>

                                                    <th>Fecha</th>

                                                    <th style="width:75px;">Tiempo</th>

                                                    <th style="width:45px;"></th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                @foreach($historiales as $nivel)

                                                    <tr>

                                                        <td>

                                                            {{$nivel->nombre_completo}}

                                                        </td>

                                                        <td>

                                                            {{$nivel->fecha}}

                                                        </td>

                                                        <td style="width:125px;">

                                                            <?php 

                                                                $minutos = $nivel->tiempoMinutos;

                                                                if($minutos>60){

                                                                    $hora = intval($minutos/60);

                                                                    $minutos = $minutos - ($hora*60);

                                                                    echo "$hora horas , $minutos minutos";

                                                                }else{

                                                                    echo "$minutos minutos";

                                                                }

                                                            ?>

                                                           

                                                        </td>

                                                        <td style="width:125px;">

                                                            <form action='{{route("historiales.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->idHistorial}},1)">

                                                                    @method("delete")

                                                                    @csrf

                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">

                                                                        <i class="fa fa-trash"></i>

                                                                    </button>

                                                                </form>

                                                        </td>

                                                    </tr>

                                                @endforeach

                                            </tbody>

                                        </table>    

                                    @endif

                                    @if($historiales->count()==0)

                                        <h2>No hay historiales</h2>

                                    @endif

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("historiales.index");?>

    <input type="hidden" value="{{$route2}}" id="route" />



    <script src="{{ URL::asset('js/historiales/list.js'); }}"></script>   

@stop

