@extends('adminlte::page')





@section('title', 'Plataforma De Capacitación')



@section('content_header')

       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js'); }}"></script>

    <div class="row">

        <div class="col-sm-10">

            <h1 class="m-0 text-dark">Materiales</h1>

        </div>

        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">

            <a href="{{route('materiales.create',[$idCurso]);}}" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>

        </div>

        <div class="col-sm-12">

            <nav aria-label="breadcrumb">

                <ol class="breadcrumb">

                    <li class="breadcrumb-item"><a href="{{route('cursos.index')}}">Cursos</a></li>

                    <li class="breadcrumb-item active" aria-current="page">Curso: {{$curso->nombre}}</li>

                </ol>

            </nav>

        </div>

    </div>

@stop



@section('content')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <div class="row" style="">

                            

                            <div class="col-sm-12">

                                <div class="">

                                    @if($materiales->count()>0)

                                        <table class="table table-striped table-bordered w-100">

                                            <thead>

                                                <tr>

                                                 

                                                  

                                                    <th>Nombre</th>

                                                    <th>Tipo</th>

                                                    <th>Visibilidad</th>

                                                    <th style="width:75px;">Acciones</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                @foreach($materiales as $nivel)

                                                    <tr>

                                                        

                                                  

                                                        <td>

                                                            {{$nivel->nombre}}

                                                        </td>

                                                        <td>

                                                            @if($nivel->tipo==0)

                                                                Imagen

                                                            @endif

                                                            @if($nivel->tipo==1)

                                                                Documento

                                                            @endif

                                                            @if($nivel->tipo==2)

                                                                Video One Drive

                                                            @endif

                                                            @if($nivel->tipo==3)

                                                                Iframe

                                                            @endif



                                                        </td>

                                                        <td>

                                                            <div class="toggle-button-cover">

                                                                    <div class="button-cover">

                                                                        <div class="button r" id="button-1">

                                                                        <input type="checkbox" onclick="changeStatus(event,'{{$nivel->idMaterial}}',{{$nivel->visibilidad}})" class="checkbox" <?php if($nivel->visibilidad==0){echo "checked";}?>/>

                                                                        <div class="knobs"></div>

                                                                        <div class="layer"></div>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                        </td>

                                                        <td style="width:125px;" >

                                                            <div class="d-flex">

                                                            <a href="{{route('materiales.edit',[$idCurso,$nivel])}}"  class="btn btn-warning text-white" style="margin-left:5px;">

                                                                        <i class="fa fa-edit"></i>

                                                            </a>

                                                            

                                                            <form action='{{route("materiales.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->idMaterial}},1)">

                                                                    @method("delete")

                                                                    @csrf

                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">

                                                                        <i class="fa fa-trash"></i>

                                                                    </button>

                                                                </form>

                                                            </div>

                                                           

                                                        </td>

                                                           

                                                        </td>

                                                    </tr>

                                                @endforeach

                                            </tbody>

                                        </table>    

                                    @endif

                                    @if($materiales->count()==0)

                                        <h2>No hay materiales</h2>

                                    @endif

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("materiales.index",[$idCurso]);?>

    <input type="hidden" value="{{$route2}}" id="route" />

    <input type="hidden" value="{{$idCurso}}" id="idCurso" />

    <script src="{{ URL::asset('js/materiales/list.js'); }}"></script>   

@stop

