<?php

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\UsuariosController;
use App\Http\Controllers\LoginController;

use App\Http\Controllers\EmpresaController;

use App\Http\Controllers\EmpleadosController;

use App\Http\Controllers\CursosController;
use App\Http\Controllers\HistorialController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\DashboardController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('admin/dashboard',[DashboardController::class, 'index'])->name('dashboard.index');
Route::get('admin/dashboard/progress',[DashboardController::class, 'progress'])->name('dashboard.progress');
Route::post('admin/dashboard/initCourse',[DashboardController::class, 'initCourse'])->name('dashboard.initCourse');
Route::post('admin/dashboard/registerView',[DashboardController::class, 'registerView'])->name('dashboard.registerView');



Route::get('admin/dashboard/curso/{idCurso}',[DashboardController::class, 'curso'])->name('dashboard.curso');


Route::resource('admin/usuarios',UsuariosController::class);
Route::post('admin/usuarios/store',[UsuariosController::class, 'store'])->name('usuarios.store');
Route::post('admin/usuarios/update',[UsuariosController::class, 'update'])->name('usuarios.update');
Route::post('admin/usuarios/destroy',[UsuariosController::class, 'destroy'])->name('usuarios.destroy');
Route::post('admin/usuarios/status',[UsuariosController::class, 'status'])->name('usuarios.status');


Route::resource('admin/empresas',EmpresaController::class);
Route::post('admin/empresas/store',[EmpresaController::class, 'store'])->name('empresas.store');
Route::post('admin/empresas/update',[EmpresaController::class, 'update'])->name('empresas.update');
Route::post('admin/empresas/destroy',[EmpresaController::class, 'destroy'])->name('empresas.destroy');
Route::post('admin/empresas/status',[EmpresaController::class, 'status'])->name('empresas.status');



Route::resource('admin/empleados',EmpleadosController::class);
Route::post('admin/empleados/store',[EmpleadosController::class, 'store'])->name('empleados.store');
Route::post('admin/empleados/update',[EmpleadosController::class, 'update'])->name('empleados.update');
Route::post('admin/empleados/destroy',[EmpleadosController::class, 'destroy'])->name('empleados.destroy');
Route::post('admin/empleados/status',[EmpleadosController::class, 'status'])->name('empleados.status');


Route::resource('admin/cursos',CursosController::class);
Route::post('admin/cursos/store',[CursosController::class, 'store'])->name('cursos.store');
Route::post('admin/cursos/update',[CursosController::class, 'update'])->name('cursos.update');
Route::post('admin/cursos/destroy',[CursosController::class, 'destroy'])->name('cursos.destroy');
Route::post('admin/cursos/status',[CursosController::class, 'status'])->name('cursos.status');



Route::get('admin/materiales/{id}',[MaterialController::class, 'index'])->name('materiales.index');
Route::get('admin/materiales/{id}/create',[MaterialController::class, 'create'])->name('materiales.create');
Route::get('admin/materiales/{id}/edit/{idMaterial}',[MaterialController::class, 'edit'])->name('materiales.edit');
Route::post('admin/materiales/store',[MaterialController::class, 'store'])->name('materiales.store');
Route::post('admin/materiales/update',[MaterialController::class, 'update'])->name('materiales.update');
Route::post('admin/materiales/destroy',[MaterialController::class, 'destroy'])->name('materiales.destroy');
Route::post('admin/materiales/status',[MaterialController::class, 'status'])->name('materiales.status');

Route::get('/admin/login',[LoginController::class, 'login'])->name('login.login');
Route::get('/admin/register',[LoginController::class, 'register'])->name('login.register');

Route::post('/logout',[LoginController::class, 'logout'])->name('login.logout');
Route::post('/loginValidator',[LoginController::class, 'loginValidator'])->name('login.loginValidator');
Route::post('/registerValidator',[LoginController::class, 'registerValidator'])->name('login.registerValidator');
Route::post('/claveValidator',[LoginController::class, 'claveValidator'])->name('login.claveValidator');

Route::resource('admin/historiales',HistorialController::class);
Route::post('admin/historiales/store',[HistorialController::class, 'store'])->name('historiales.store');
Route::post('admin/historiales/update',[HistorialController::class, 'update'])->name('historiales.update');
Route::post('admin/historiales/destroy',[HistorialController::class, 'destroy'])->name('historiales.destroy');


Route::get('/authlogin',[LoginController::class, 'authlogin'])->name('login.authlogin');